CREATE DATABASE GrafikUczelniZmiana
GO

USE GrafikUczelniZmiana
GO

CREATE TABLE Budynki (
	KodBudynku nvarchar (3) NOT NULL ,
	NazwaBudynku nvarchar (25) NULL ,
	LiczbaKondygnacji smallint NULL ,
	Winda bit NOT NULL ,
	Parking bit NOT NULL 
)
GO

CREATE TABLE Dziedziny (
	IDDziedziny nvarchar (10) NOT NULL ,
	OpisDziedziny nvarchar (75) NULL ,
	IDWydzialu int NULL 
)
GO

CREATE TABLE Sale (
	IDSali int IDENTITY (1, 1) NOT NULL ,
	KodBudynku nvarchar (3) NULL ,
	DostTelefonu bit NOT NULL 
)
GO

CREATE TABLE Zajecia (
	IDZajec int IDENTITY (1, 1) NOT NULL ,
	IDPrzedmiotu int NULL ,
	IDSali int NULL ,
	PunktyEdukacyjne tinyint NULL ,
    DataRozpoczecia date NULL ,
	GodzinaRozpoczecia time NULL ,
	CzasTrwania smallint NULL ,
	PlanNaPoniedzialek bit NOT NULL ,
	PlanNaWtorek bit NOT NULL ,
	PlanNaSrode bit NOT NULL ,
	PlanNaCzwartek bit NOT NULL ,
	PlanNaPiatek bit NOT NULL ,
	PlanNaSobote bit NOT NULL 
)
GO

CREATE TABLE Wydzialy (
	IDWydzialu int IDENTITY (1, 1) NOT NULL ,
	NazwaWydzialu nvarchar (50) NULL ,
	KierownikWydzialu int NULL 
)
GO

CREATE TABLE Wykladowcy (
	IDPracownika int NOT NULL ,
	Tytul nvarchar (50) NULL ,
	Status nvarchar (12) NULL ,
	Etat bit NOT NULL 
)
GO

CREATE TABLE Dziedziny_wykladowcow (
	IDPracownika int NOT NULL ,
	IDDziedziny nvarchar (10) NOT NULL 
)
GO

CREATE TABLE Zajecia_wykladowcow (
	IDZajec int NOT NULL ,
	IDPracownika int NOT NULL 
)
GO

CREATE TABLE Przedmioty_wykladowcow (
	IDPracownika int NOT NULL ,
	IDPrzedmiotu int NOT NULL ,
	OcenaBieglosci real NULL 
)
GO

CREATE TABLE Kierunki (
    IDKierunku int NOT NULL ,
    Kierunek nvarchar (20) NULL 
        )
GO

CREATE TABLE Pracownicy (
	IDPracownika int IDENTITY (1, 1) NOT NULL ,
	ImiePracownika nvarchar (25) NULL ,
	NazwiskoPracownika nvarchar (25) NULL ,
	AdresPracownika nvarchar (50) NULL ,
	MiastoPracownika nvarchar (30) NULL ,
	StanZamPracownika nvarchar (2) NULL ,
	KodPocztowyPracownika nvarchar (5) NULL ,
	NumKierPracownika nvarchar (5) NULL ,
	TelefonPracownika nvarchar (8) NULL ,
	Wynagrodzenie money NULL ,
	DataZatrudnienia date NULL ,
	Stanowisko nvarchar (50) NULL 
)
GO

CREATE TABLE Status_zajec_studenta (
	StatusZajec int IDENTITY (1, 1) NOT NULL ,
	OpisStatusuZajec nvarchar (50) NULL 
)
GO

CREATE TABLE Grafik_studenta (
	IDStudenta int NOT NULL ,
	IDZajec int NOT NULL ,
	StatusZajec int NULL ,
	Ocena real NULL 
)
GO

CREATE TABLE Studenci (
	IDStudenta int IDENTITY (1, 1) NOT NULL ,
	ImieStudenta nvarchar (25) NULL ,
	NazwiskoStudenta nvarchar (25) NULL ,
	AdresStudenta nvarchar (50) NULL ,
	MiastoStudenta nvarchar (30) NULL ,
	StanZamStudenta nvarchar (2) NULL ,
	KodPocztowyStudenta nvarchar (5) NULL ,
	NumKierStudenta nvarchar (5) NULL ,
	TelefonStudenta nvarchar (8) NULL ,
	SredniaOcenStudenta float NULL ,
    KierunekStudiow int NULL 
)
GO

CREATE TABLE Przedmioty (
	IDPrzedmiotu int IDENTITY (1, 1) NOT NULL ,
	IDDziedziny nvarchar (10) NULL ,
	KodPrzedmiotu nvarchar (8) NULL ,
	NazwaPrzedmiotu nvarchar (50) NULL ,
    Wymagania nvarchar (8) NULL ,
	OpisPrzedmiotu ntext NULL 
) 
GO

ALTER TABLE Budynki ADD 
	CONSTRAINT Dost_windy_domyslny DEFAULT (0) FOR Winda,
	CONSTRAINT Dost_parkingu_domyslny DEFAULT (0) FOR Parking,
	CONSTRAINT Budynki_PK PRIMARY KEY   
	(
		KodBudynku
	)  
GO

 CREATE  INDEX LiczbaKondygnacji ON Budynki(LiczbaKondygnacji)
GO

ALTER TABLE Dziedziny ADD 
	CONSTRAINT ID_dziedziny_wydzialu_domyslny DEFAULT (0) FOR IDWydzialu,
	CONSTRAINT Dziedziny_PK PRIMARY KEY   
	(
		IDDziedziny
	)  
GO

 CREATE  INDEX IDWydzialu ON Dziedziny(IDWydzialu)
GO

ALTER TABLE Sale ADD 
	CONSTRAINT Dost_telefonu_domyslny DEFAULT (0) FOR DostTelefonu,
	CONSTRAINT Sale_PK PRIMARY KEY   
	(
		IDSali
	)  
GO

 CREATE  INDEX BuildingNumber ON Sale(KodBudynku)
GO

ALTER TABLE Zajecia ADD 
	CONSTRAINT C_ID_przedmiotu_domyslny DEFAULT (0) FOR IDPrzedmiotu,
	CONSTRAINT C_ID_sali_domyslny DEFAULT (0) FOR IDSali,
	CONSTRAINT Punkty_edukacyjne_domyslny DEFAULT (0) FOR PunktyEdukacyjne,
	CONSTRAINT CzasTrwania_domyslny DEFAULT (0) FOR CzasTrwania,
	CONSTRAINT Graf_na_pon_domyslny DEFAULT (0) FOR PlanNaPoniedzialek,
	CONSTRAINT Graf_na_wt_domyslny DEFAULT (0) FOR PlanNaWtorek,
	CONSTRAINT Graf_na_sr_domyslny DEFAULT (0) FOR PlanNaSrode,
	CONSTRAINT Graf_na_czw_domyslny DEFAULT (0) FOR PlanNaCzwartek,
	CONSTRAINT Graf_na_pia_domyslny DEFAULT (0) FOR PlanNaPiatek,
	CONSTRAINT Graf_na_sob_domyslny DEFAULT (0) FOR PlanNaSobote,
	CONSTRAINT Zajecia_PK PRIMARY KEY   
	(
		IDZajec
	)  
GO

 CREATE  INDEX IDPrzedmiotu ON Zajecia(IDPrzedmiotu)
GO

 CREATE  INDEX IDSali ON Zajecia(IDSali)
GO

ALTER TABLE Wydzialy ADD 
	CONSTRAINT Kier_wydzialu_domyslny DEFAULT (0) FOR KierownikWydzialu,
	CONSTRAINT Wydzialy_PK PRIMARY KEY  
	(
		IDWydzialu
	)  
GO

 CREATE  INDEX PracownicyWydzialy ON Wydzialy(KierownikWydzialu)
GO

ALTER TABLE Wykladowcy ADD 
	CONSTRAINT Etatowy_domyslny DEFAULT (0) FOR Etat,
	CONSTRAINT Wykladowcy_PK PRIMARY KEY   
	(
		IDPracownika
	)  
GO

ALTER TABLE Dziedziny_wykladowcow ADD 
	CONSTRAINT FC_ID_kategorii_domyslny DEFAULT ('KSI') FOR IDDziedziny,
	CONSTRAINT Wykladowcy_Dziedziny_PK PRIMARY KEY   
	(
		IDPracownika,
		IDDziedziny
	)  
GO

 CREATE  INDEX IDDziedzinyWykladowcy_Dziedziny ON Dziedziny_wykladowcow(IDDziedziny)
GO

 CREATE  INDEX PracownicyIDWykladowcy_Dziedziny ON Dziedziny_wykladowcow(IDPracownika)
GO

ALTER TABLE Zajecia_wykladowcow ADD 
	CONSTRAINT Wykladowcy_Zajecia_PK PRIMARY KEY  
	(
		IDZajec,
		IDPracownika
	)  
GO

 CREATE  INDEX ZajeciaWykladowcy_Zajecia ON Zajecia_wykladowcow(IDZajec)
GO

 CREATE  INDEX PracownicyWykladowcy_Zajecia ON Zajecia_wykladowcow(IDPracownika)
GO

ALTER TABLE Przedmioty_wykladowcow ADD 
	CONSTRAINT FS_ID_pracownika_domyslny DEFAULT (0) FOR IDPracownika,
	CONSTRAINT FS_ID_przedmiotu_domyslny DEFAULT (0) FOR IDPrzedmiotu,
	CONSTRAINT Ocena_bieglosci_domyslny DEFAULT (0) FOR OcenaBieglosci,
	CONSTRAINT Wykladowcy_Przedmioty_PK PRIMARY KEY   
	(
		IDPracownika,
		IDPrzedmiotu
	)  
GO

 CREATE  INDEX PracownicyIDWykladowcy_Przedmioty ON Przedmioty_wykladowcow(IDPracownika)
GO

 CREATE  INDEX PrzedmiotyWykladowcy_Przedmioty ON Przedmioty_wykladowcow(IDPrzedmiotu)
GO

ALTER TABLE Pracownicy ADD 
	CONSTRAINT taff_PK PRIMARY KEY  
	(
		IDPracownika
	)  
GO

 CREATE  INDEX PracownicyKodPocztowy ON Pracownicy(KodPocztowyPracownika)
GO

 CREATE  INDEX NumKierStudenta ON Pracownicy(NumKierPracownika)
GO

ALTER TABLE Kierunki ADD
        CONSTRAINT Kierunki_PK PRIMARY KEY
        (
               IDKierunku
        )
GO

ALTER TABLE Status_zajec_studenta ADD 
	CONSTRAINT Status_zajec_studenta_PK PRIMARY KEY  
	(
		StatusZajec
	)  
GO

ALTER TABLE Grafik_studenta ADD 
	CONSTRAINT SS_Status_zajec_domyslny DEFAULT (0) FOR StatusZajec,
	CONSTRAINT Ocena_domyslny DEFAULT (0) FOR Ocena,
	CONSTRAINT Grafik_studenta_PK PRIMARY KEY   
	(
		IDStudenta,
		IDZajec
	)  
GO

 CREATE  INDEX ZajeciaGrafik_studenta ON Grafik_studenta(IDZajec)
GO

 CREATE  INDEX Status_zajec_studentaGrafik_studenta ON Grafik_studenta(StatusZajec)
GO

 CREATE  INDEX StudenciGrafik_studenta ON Grafik_studenta(IDStudenta)
GO

ALTER TABLE Studenci ADD 
	CONSTRAINT StudGPA_domyslny DEFAULT (0) FOR SredniaOcenStudenta,
	CONSTRAINT Studenci_PK PRIMARY KEY  
	(
		IDStudenta
	)  
GO

 CREATE  INDEX NumKierStudenta ON Studenci(NumKierStudenta)
GO

 CREATE  INDEX KodPocztowyStudenta ON Studenci(KodPocztowyStudenta)
GO

 CREATE  INDEX KierunekStudiow ON Studenci(KierunekStudiow)
GO

ALTER TABLE Przedmioty ADD 
	CONSTRAINT Przedmioty_PK PRIMARY KEY   
	(
		IDPrzedmiotu
	)  
GO

 CREATE  INDEX IDDziedziny ON Przedmioty(IDDziedziny)
GO

 CREATE  UNIQUE  INDEX KodPrzedmiotu ON Przedmioty(KodPrzedmiotu)
GO

 CREATE  INDEX WymPrzedm ON Przedmioty(Wymagania)
GO

ALTER TABLE Dziedziny ADD 
	CONSTRAINT Dziedziny_FK00 FOREIGN KEY 
	(
		IDWydzialu
	) REFERENCES Wydzialy (
		IDWydzialu
	)
GO

ALTER TABLE Sale ADD 
	CONSTRAINT Sale_FK00 FOREIGN KEY 
	(
		KodBudynku
	) REFERENCES Budynki (
		KodBudynku
	)
GO

ALTER TABLE Zajecia ADD 
	CONSTRAINT Zajecia_FK00 FOREIGN KEY 
	(
		IDSali
	) REFERENCES Sale (
		IDSali
	),
	CONSTRAINT Zajecia_FK01 FOREIGN KEY 
	(
		IDPrzedmiotu
	) REFERENCES Przedmioty (
		IDPrzedmiotu
	)
GO

ALTER TABLE Wydzialy ADD 
	CONSTRAINT Wydzialy_FK00 FOREIGN KEY 
	(
		KierownikWydzialu
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Wykladowcy ADD 
	CONSTRAINT Wykladowcy_FK00 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Dziedziny_wykladowcow ADD 
	CONSTRAINT Wykladowcy_Dziedziny_FK00 FOREIGN KEY 
	(
		IDDziedziny
	) REFERENCES Dziedziny (
		IDDziedziny
	),
	CONSTRAINT Wykladowcy_Dziedziny_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	)
GO

ALTER TABLE Zajecia_wykladowcow ADD 
	CONSTRAINT Wykladowcy_Zajecia_FK00 FOREIGN KEY 
	(
		IDZajec
	) REFERENCES Zajecia (
		IDZajec
	),
	CONSTRAINT Wykladowcy_Zajecia_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	),
        CONSTRAINT Wykladowcy_Zajecia_FK02 FOREIGN KEY
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	)
GO

ALTER TABLE Przedmioty_wykladowcow ADD 
	CONSTRAINT Wykladowcy_Przedmioty_FK00 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	),
	CONSTRAINT Wykladowcy_Przedmioty_FK01 FOREIGN KEY 
	(
		IDPrzedmiotu
	) REFERENCES Przedmioty (
		IDPrzedmiotu
	)
GO

ALTER TABLE Studenci ADD
        CONSTRAINT Studenci_FK00 FOREIGN KEY
        (
                KierunekStudiow
        ) REFERENCES Kierunki (
                IDKierunku
        )
GO

ALTER TABLE Grafik_studenta ADD 
	CONSTRAINT Grafik_studenta_FK00 FOREIGN KEY 
	(
		IDZajec
	) REFERENCES Zajecia (
		IDZajec
	),
	CONSTRAINT Grafik_studenta_FK01 FOREIGN KEY 
	(
		StatusZajec
	) REFERENCES Status_zajec_studenta (
		StatusZajec
	),
	CONSTRAINT Grafik_studenta_FK02 FOREIGN KEY 
	(
		IDStudenta
	) REFERENCES Studenci (
		IDStudenta
	)
GO

ALTER TABLE Przedmioty ADD 
	CONSTRAINT Przedmioty_FK00 FOREIGN KEY 
	(
		IDDziedziny
	) REFERENCES Dziedziny (
		IDDziedziny
	),
        CONSTRAINT Przedmioty_FK01 FOREIGN KEY
	(
		Wymagania
	) REFERENCES Przedmioty (
		KodPrzedmiotu
	)
GO

